// Offscreen script to keep the background service worker alive
// ✅ Properly cleans up when extension is disabled/reloaded

let keepAliveInterval = null;
let failureCount = 0;
const MAX_FAILURES = 3;

function startKeepAlive() {
    keepAliveInterval = setInterval(async () => {
        try {
            await chrome.runtime.sendMessage({ action: 'keepAlive' });
            failureCount = 0; // Reset on success
        } catch (e) {
            failureCount++;
            console.log('Keep alive failed', e);

            // ✅ Close offscreen document after multiple failures
            if (failureCount >= MAX_FAILURES) {
                console.log('Maximum failures reached - closing offscreen document');
                cleanup();
            }
        }
    }, 20000); // Send message every 20 seconds
}

function cleanup() {
    if (keepAliveInterval) {
        clearInterval(keepAliveInterval);
        keepAliveInterval = null;
    }

    // ✅ Close the offscreen document
    try {
        window.close();
    } catch (e) {
        console.log('Error closing window:', e);
    }
}

// ✅ Listen for messages to stop keep-alive
chrome.runtime.onMessage.addListener((message, sender, sendResponse) => {
    if (message.action === 'closeOffscreen') {
        console.log('Received close command');
        cleanup();
        sendResponse({ success: true });
    }
});

// Start keep-alive
startKeepAlive();

// ✅ Cleanup on page unload
window.addEventListener('beforeunload', cleanup);
